% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GetParamInfo.R
\name{GetParamInfo}
\alias{GetParamInfo}
\title{Information on  Optimizely entities}
\usage{
GetParamInfo(id, param)
}
\arguments{
\item{id}{Identifier for project entity i.e. goal id, audience id, user list id, dimension id}

\item{param}{alphabet character  to identify the parameter list
\itemize{
\item G - Goals
\item T - Targeting (user) lists
\item V - Variations
\item A - Audience
\item D - Dimensions
}}
}
\value{
data frame - of goals/audiences/targeting lists/dimensions in a project
}
\description{
Query Optimizely to obtain information on project entities
\describe{
 \item{ Goal}{A user list is a set of user identifiers that you have uploaded to Optimizely. Membership in a targeting list can be used to define an Optimizely audience, so you can target experiments only to a particular set of users.}
\item{ Audience }{ An Audience is a group of visitors that match set conditions. You can target an experiment to one or more audiences, or you can segment experiment results to see how different audiences performed.}
\item{ Targeting(User) list}{ A user list is a set of user identifiers that you have uploaded to Optimizely. Membership in a targeting list can be used to define an Optimizely audience}
\item{Dimension}{ Dimensions are attributes of visitors to your website or mobile app, such as demographic data, behavioral characteristics, or any other information particular to a visitor. Dimensions can be used to construct audiences and segment experiment results.}
\item{Variation}{Every experiment contains a set of variations that each change the visitor's experience in a different way. Variations define the code that should be applied on a page to change the experience, and the percentage of visitors who should see that code. A standard 'A/B' test has two variations (including the original), and Optimizely supports adding many more variations.}
}
\url{https://help.optimizely.com}
}
\examples{
\dontrun{
# Information for an dimension
# Use set_token to assign account token
set_token('123456789101112:zzzzz')
# Lists all audiences in a project
final.df<-GetParamInfo('1234567',param='A')
# Lists goals in a project (default)
final.df<-GetParamInfo('1234567')
}
}
\seealso{
\code{\link{GetProjectList}}
}

