% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\docType{methods}
\name{postgres-transactions}
\alias{postgres-transactions}
\alias{dbBegin,PqConnection-method}
\alias{dbCommit,PqConnection-method}
\alias{dbRollback,PqConnection-method}
\title{Transaction management.}
\usage{
\S4method{dbBegin}{PqConnection}(conn, ...)

\S4method{dbCommit}{PqConnection}(conn, ...)

\S4method{dbRollback}{PqConnection}(conn, ...)
}
\arguments{
\item{conn}{a \linkS4class{PqConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{...}{Unused, for extensibility.}
}
\value{
A boolean, indicating success or failure.
}
\description{
\code{dbBegin()} starts a transaction. \code{dbCommit()} and \code{dbRollback()}
end the transaction by either committing or rolling back the changes.
}
\examples{
# For running the examples on systems without PostgreSQL connection:
run <- postgresHasDefault()

library(DBI)
if (run) con <- dbConnect(RPostgres::Postgres())
if (run) dbWriteTable(con, "USarrests", datasets::USArrests, temporary = TRUE)
if (run) dbGetQuery(con, 'SELECT count(*) from "USarrests"')

if (run) dbBegin(con)
if (run) dbExecute(con, 'DELETE from "USarrests" WHERE "Murder" > 1')
if (run) dbGetQuery(con, 'SELECT count(*) from "USarrests"')
if (run) dbRollback(con)

# Rolling back changes leads to original count
if (run) dbGetQuery(con, 'SELECT count(*) from "USarrests"')

if (run) dbRemoveTable(con, "USarrests")
if (run) dbDisconnect(con)
}
