% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PqResult.R, R/dbBind_PqResult.R,
%   R/dbClearResult_PqResult.R, R/dbFetch_PqResult.R,
%   R/dbHasCompleted_PqResult.R, R/dbSendQuery_PqConnection.R
\name{postgres-query}
\alias{postgres-query}
\alias{dbBind_PqResult}
\alias{dbBind,PqResult-method}
\alias{dbClearResult_PqResult}
\alias{dbClearResult,PqResult-method}
\alias{dbFetch_PqResult}
\alias{dbFetch,PqResult-method}
\alias{dbHasCompleted_PqResult}
\alias{dbHasCompleted,PqResult-method}
\alias{dbSendQuery_PqConnection}
\alias{dbSendQuery,PqConnection-method}
\title{Execute a SQL statement on a database connection}
\usage{
\S4method{dbBind}{PqResult}(res, params, ...)

\S4method{dbClearResult}{PqResult}(res, ...)

\S4method{dbFetch}{PqResult}(res, n = -1, ..., row.names = FALSE)

\S4method{dbHasCompleted}{PqResult}(res, ...)

\S4method{dbSendQuery}{PqConnection}(conn, statement, params = NULL, ..., immediate = FALSE)
}
\arguments{
\item{res}{Code a \linkS4class{PqResult} produced by
\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}.}

\item{params}{A list of query parameters to be substituted into
a parameterised query. Query parameters are sent as strings, and the
correct type is imputed by PostgreSQL. If this fails, you can manually
cast the parameter with e.g. \code{"$1::bigint"}.}

\item{...}{Other arguments needed for compatibility with generic (currently
ignored).}

\item{n}{Number of rows to return. If less than zero returns all rows.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{conn}{A \linkS4class{PqConnection} created by \code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{An SQL string to execute.}

\item{immediate}{If \code{TRUE}, uses the \code{PGsendQuery()} API instead of \code{PGprepare()}.
This allows to pass multiple statements and turns off the ability to pass parameters.}
}
\description{
To retrieve results a chunk at a time, use \code{dbSendQuery()},
\code{dbFetch()}, then \code{dbClearResult()}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{dbGetQuery()} which sends,
fetches and clears for you.
}
\section{Multiple queries and statements}{

With \code{immediate = TRUE}, it is possible to pass multiple queries or statements,
separated by semicolons.
For multiple statements, the resulting value of \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}}
corresponds to the total number of affected rows.
If multiple queries are used, all queries must return data with the same
column names and types.
Queries and statements can be mixed.
}

\examples{
\dontshow{if (postgresHasDefault()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(DBI)
db <- dbConnect(RPostgres::Postgres())
dbWriteTable(db, "usarrests", datasets::USArrests, temporary = TRUE)

# Run query to get results as dataframe
dbGetQuery(db, "SELECT * FROM usarrests LIMIT 3")

# Send query to pull requests in batches
res <- dbSendQuery(db, "SELECT * FROM usarrests")
dbFetch(res, n = 2)
dbFetch(res, n = 2)
dbHasCompleted(res)
dbClearResult(res)

dbRemoveTable(db, "usarrests")

dbDisconnect(db)
\dontshow{\}) # examplesIf}
}
