% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbQuoteIdentifier_PqConnection_Id.R,
%   R/dbQuoteIdentifier_PqConnection_SQL.R,
%   R/dbQuoteIdentifier_PqConnection_character.R,
%   R/dbQuoteLiteral_PqConnection.R, R/dbQuoteString_PqConnection_SQL.R,
%   R/dbQuoteString_PqConnection_character.R,
%   R/dbUnquoteIdentifier_PqConnection_SQL.R, R/quote.R
\name{quote}
\alias{quote}
\alias{dbQuoteIdentifier_PqConnection_Id}
\alias{dbQuoteIdentifier,PqConnection,Id-method}
\alias{dbQuoteIdentifier_PqConnection_SQL}
\alias{dbQuoteIdentifier,PqConnection,SQL-method}
\alias{dbQuoteIdentifier_PqConnection_character}
\alias{dbQuoteIdentifier,PqConnection,character-method}
\alias{dbQuoteLiteral_PqConnection}
\alias{dbQuoteLiteral,PqConnection-method}
\alias{dbQuoteString_PqConnection_SQL}
\alias{dbQuoteString,PqConnection,SQL-method}
\alias{dbQuoteString_PqConnection_character}
\alias{dbQuoteString,PqConnection,character-method}
\alias{dbUnquoteIdentifier_PqConnection_SQL}
\alias{dbUnquoteIdentifier,PqConnection,SQL-method}
\title{Quote postgres strings, identifiers, and literals}
\usage{
\S4method{dbQuoteIdentifier}{PqConnection,Id}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,character}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection}(conn, x, ...)

\S4method{dbQuoteString}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteString}{PqConnection,character}(conn, x, ...)

\S4method{dbUnquoteIdentifier}{PqConnection,SQL}(conn, x, ...)
}
\arguments{
\item{conn}{A \linkS4class{PqConnection} created by \code{dbConnect()}}

\item{x}{A character vector to be quoted.}

\item{...}{Other arguments needed for compatibility with generic (currently
ignored).}
}
\description{
If an object of class \link{Id} is used for \code{dbQuoteIdentifier()}, it needs
at most one \code{table} component and at most one \code{schema} component.
}
\examples{
\dontshow{if (postgresHasDefault()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(DBI)
con <- dbConnect(RPostgres::Postgres())

x <- c("a", "b c", "d'e", "\\\\f")
dbQuoteString(con, x)
dbQuoteIdentifier(con, x)
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
