% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{control_cluster_gene}
\alias{control_cluster_gene}
\title{control_cluster_gene}
\usage{
control_cluster_gene(
  data,
  method.dist = "euclidean",
  sel.Sample = "all",
  method.clust = "average",
  pairwise.FCh = FALSE,
  x.axis.title = "Genes",
  y.axis.title = "Height",
  label.size = 0.8,
  plot.title = "",
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "control_clust_genes"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.
Also, table with fold change values returned from RQ_dCt() and RQ_ddCt() functions can be used,
but in such situation a pairwise.FCh parameter must be set to TRUE.}

\item{method.dist}{Character: name of method used for calculation of distances, derived from stats::dist() function,
must be one of "euclidean" (default) , "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{sel.Sample}{Character vector with names of samples to include, or "all" (default) to use all samples.}

\item{method.clust}{Character: name of used method for agglomeration, derived from stats::hclust() function,
must be one of "ward.D", "ward.D2", "single", "complete", "average" (default), "mcquitty", "median" or "centroid".}

\item{pairwise.FCh}{Logical: If fold change values returned from RQ_dCt() and RQ_ddCt() functions
in a pairwise approach are used as data, this parameter should be set to TRUE, otherwise to FALSE (default).}

\item{x.axis.title}{Character: title of x axis. Default to "Genes".}

\item{y.axis.title}{Character: title of y axis. Default to "Height".}

\item{label.size}{Numeric: size of text labels. Default to 0.8.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "control_clust_genes".}
}
\value{
Plot with hierarchical clustering of genes, displayed on the graphic device.
}
\description{
This function performs hierarchical clustering of genes based on the data, useful to gain insight into similarity in expression of analyzed genes.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
control_cluster_gene(data.dCt)

}
