% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.scatterplot.ggplot.R
\name{sym.scatterplot.ggplot}
\alias{sym.scatterplot.ggplot}
\title{Symbolic Scatter GGPlot}
\usage{
sym.scatterplot.ggplot(sym.var.x, sym.var.y, labels = FALSE, ...)
}
\arguments{
\item{sym.var.x}{First symbolic variable.}

\item{sym.var.y}{Second symbolic variable.}

\item{labels}{As in ggplot.}

\item{...}{As in ggplot.}
}
\value{
return a ggplot graphic.
}
\description{
This function could be use to plot two symbolic variables in a X-Y plane using ggplot
R package.
}
\examples{
data(lynne1)
class(lynne1) <- c('sym.data.table')
sym.scatterplot.ggplot(lynne1[,1], lynne1[,3],labels=TRUE)
data(oils)
sym.scatterplot.ggplot(oils[,2], oils[,3],labels=TRUE)
}
\references{
Bock H-H. and Diday E. (eds.) (2000).
Analysis of Symbolic Data. Exploratory methods for extracting statistical information
from complex data. Springer, Germany.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\seealso{
sym.scatterplot
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{ggplot}
