% Generated by roxygen2 (4.0.1): do not edit by hand
\name{phantom}
\alias{phantom}
\title{Start a phantomjs binary in webdriver mode.}
\usage{
phantom(pjs_cmd = "", port = 4444L, extras = "", ...)
}
\arguments{
\item{pjs_cmd}{The name, full or partial path of a phantomjs executable. This is optional only state if the executable is not in your path.}

\item{port}{An integer giving the port on which phantomjs will listen. Defaults to 4444. format [[<IP>:]<PORT>]}

\item{extras}{An optional character vector: see 'Details'.}

\item{...}{Arguments to pass to \code{\link{system2}}}
}
\description{
\code{phantom}
A utility function to control a phantomjs binary in webdriver mode.
}
\section{Detail}{
 phantom() is used to start a phantomjs binary in webdriver mode. This can be used to drive
a phantomjs binary on a machine without selenium server.
Argument extras can be used to specify optional extra command line arguments see \url{http://phantomjs.org/api/command-line.html}
}

\section{Value}{
 phantom() returns a list with two functions:
\describe{
\item{getPID}{returns the process id of the phantomjs binary running in webdriver mode.}
\item{stop}{terminates the phantomjs binary running in webdriver mode using \code{\link{pskill}}}
}
}
\examples{
\dontrun{
pJS <- phantom()
# note we are running here without a selenium server phantomjs is listening on port 4444
# in webdriver mode
remDr <- remoteDriver(browserName = "phantomjs")
remDr$open()
remDr$navigate("http://www.google.com/ncr")
remDr$screenshot(display = TRUE)
webElem <- remDr$findElement("name", "q")
webElem$sendKeysToElement(list("HELLO WORLD"))
remDr$screenshot(display = TRUE)
remDr$close()
# note remDr$closeServer() is not called here. We stop the phantomjs binary using
pJS$stop()
}
}

