% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueueSummary.R
\name{QueueSummary}
\alias{QueueSummary}
\title{Run a Summary Report}
\usage{
QueueSummary(reportsuite.ids, date, metrics, interval.seconds = 5,
  max.attempts = 120, validate = TRUE)
}
\arguments{
\item{reportsuite.ids}{Report suite ids}

\item{date}{Time period for the report (see Description)}

\item{metrics}{List of metrics to include in the report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{Weather to submit report definition for validation before requesting the data.}
}
\value{
Data frame
}
\description{
A QueueSummary report is a summary report of metrics for one or more report
suites for a given time period. Time period can be specified as year only ("2015"),
year-month ("2015-04") or year-month-day ("2015-04-20")
}
\details{
The QueueSummary function returns a data frame containing a metric summary for the time period
selected.

Because of the Reporting API structure, this function first requests the
report, then checks the reporting queue to see if the report is completed, and
when the report returns as "done" pulls the report from the API. This checking
process will occur up to the specified number of times (default 120), with a
delay between status checks (default 5 seconds). If the report does not return
as "done" after the number of tries have completed, the function will return an
error message.
}
\examples{
\dontrun{

aa <- QueueSummary("zwitchdev", "2015", c("pageviews", "visits"))

}

}

