% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/normImage.R
\name{normImage}
\alias{normImage}
\title{Normalize Raster Images: Center and Scale}
\usage{
normImage(img, norm = TRUE, ...)
}
\arguments{
\item{img}{Raster* object. Image to transform. Transformation will be performed separately for each layer.}

\item{norm}{Logical. Perform normalization (scaling) in addition to centering, i.e. divide by standard deviation.}

\item{...}{further arguments passed to \link[raster]{writeRaster}.}
}
\value{
Returns a Raster* with the same number layers as input layers with each layer being centered and optionally normalized.
}
\description{
For each pixel subtracts the mean of the raster layer and optionally divide by its standard deviation.
}
\examples{
library(raster)
## Load example data
data(rlogo)

## Normalization: Center and Scale
rlogo_center_norm <- normImage(rlogo)
hist(rlogo_center_norm)

## Centering
rlogo_center <- normImage(rlogo, norm = FALSE)
}

