% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{can.template}
\alias{can.template}
\title{Generating templates for canton-level data of Switzerland}
\usage{
can.template(year, add_geodata_path = ".", endofyear = FALSE,
  cantons = NULL)
}
\arguments{
\item{year}{numeric. Available with package: \code{2016}. For additional years, see: \code{map.load}.}

\item{add_geodata_path}{a character string with the path to the folder where additional geodata is saved.}

\item{endofyear}{if \code{TRUE}, cantons as by December 31 of \code{year} are used for the template.}

\item{cantons}{input either numeric (canton identification numbers) or character (canton abbreviations)
vector to create tailor-made templates.}
}
\description{
\code{can.template} offers the possbility to generate Swiss canton-level data templates in
    the form of data frames. The package comes with data for \code{2016}.  Additional data can be
    downloaded with \code{map.load}.  The templates contain the canton identification numbers
    as used by the Swiss Federal Statistical Office and the canton abbreviations.
}
\examples{
# Generating template:
can.template(2016)
}
