% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscape.R
\name{getGenscapeStorageOil}
\alias{getGenscapeStorageOil}
\title{\code{getGenscapeStorageOil}}
\usage{
getGenscapeStorageOil(
  feed = "owner-volumes",
  regions = "Canada",
  products = "Crude",
  revision = "revised",
  limit = 5000,
  offset = 0,
  startDate = "2011-01-01",
  endDate = as.character(Sys.Date()),
  apikey = "yourapikey"
)
}
\arguments{
\item{feed}{"owner-volumes" DEFAULT or "tank-volumes"}

\item{regions}{See API webpage. Multiple values separated by commas e.g. "Canada, Cushing").}

\item{products}{See API webpage. Multiple values separated by commas e.g. "Crude, JetFuel").}

\item{revision}{See API webpage.}

\item{limit}{See API webpage. Max 5000}

\item{offset}{See API webpage.}

\item{startDate}{"yyyy-mm-dd" as character string}

\item{endDate}{"yyyy-mm-dd" as character string}

\item{apikey}{Your API key as a character string.}
}
\value{
wide data frame
}
\description{
Returns oil storage data from Genscape API.You need your own credentials.
Refer to API documentation for argument values.
https://developer.genscape.com/docs/services/oil-storage/operations/StorageVolumeByOwnerGet
}
\examples{
\dontrun{
getGenscapeStorageOil(feed = "owner-volumes",regions = "Canada", products = "Crude",
evision = "revised", limit = 5000, offset = 0, startDate = "2011-01-01", endDate = "2020-11-01"
apikey = "<yourapikey>")
}
}
\author{
Philippe Cote
}
