% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morningstar.R
\name{getCurve}
\alias{getCurve}
\title{Morningstar Commodities API forward curves}
\usage{
getCurve(
  feed = "Crb_Futures_Price_Volume_And_Open_Interest",
  contract = "CL",
  date = "2020-08-10",
  fields = c("Open, High, Low, Close"),
  iuser = "x@xyz.com",
  ipassword = "pass"
)
}
\arguments{
\item{feed}{Morningstar Feed Table e.g "Crb_Futures_Price_Volume_And_Open_Interest".}

\item{contract}{Morningstar contract root e.g. "CL" for CME WTI and "BG" for ICE Brent.}

\item{date}{From date as character string.}

\item{fields}{Defaults to c("Open, High, Low, Close").}

\item{iuser}{Morningstar user name as character - sourced locally in examples.}

\item{ipassword}{Morningstar user password as character - sourced locally in examples.}
}
\value{
wide data frame
}
\description{
Returns forward curves from Morningstar API. See below for current feeds supported.
You need your own credentials with Morningstar.
}
\section{Current Feeds Supported}{

\itemize{
\item Crb_Futures_Price_Volume_And_Open_Interest
\item CME_NymexFuturesIntraday_EOD
\item ICE_EuroFutures and ICE_EuroFutures_continuous
}
}

\examples{
\dontrun{
# CME WTI Futures
getCurve(
  feed = "Crb_Futures_Price_Volume_And_Open_Interest", contract = "CL",
  date = "2020-07-13", fields = c("Open, High, Low, Close"),
  iuser = "x@xyz.com", ipassword = "pass"
)

getCurve(
  feed = "Crb_Futures_Price_Volume_And_Open_Interest", contract = "BG",
  date = "2020-07-13", fields = c("Open, High, Low, Close"),
  iuser = "x@xyz.com", ipassword = "pass"
)

getCurve(
  feed = "LME_ClosingPriceDelayed", contract = "AHD",
  date = "2021-06-25", fields = c("Last_Price"),
  iuser = "x@xyz.com", ipassword = "pass"
)
}

}
\author{
Philippe Cote
}
