% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garch.R
\name{garch}
\alias{garch}
\title{Wrapper for a Garch(1,1) returning either a plot or data.}
\usage{
garch(x = x, out = TRUE)
}
\arguments{
\item{x}{Wide dataframe with date column and single series (univariate).}

\item{out}{"chart" to return chart, "data" to return data or "fit" for garch fit output}
}
\value{
plot.xts object or xts series
}
\description{
Computes annualised Garch(1,1) volatilities using fGarch package.
}
\examples{
\dontrun{
x <- dflong \%>\% dplyr::filter(series == "CL01")
x <- returns(df = x, retType = "rel", period.return = 1, spread = TRUE)
x <- rolladjust(x = x, commodityname = c("cmewti"), rolltype = c("Last.Trade"))
summary(garch(x = x, out = "fit"))
garch(x = x, out = "chart")
garch(x = x, out = "data")
}
}
\author{
Philippe Cote
}
