% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{normalizeDate}
\alias{normalizeDate}
\title{Reformat a Date String}
\usage{
normalizeDate(d, asDate = TRUE, months = c(jan = "january", feb =
  "februrary", mar = "march", apr = "april", may = "may", jun = "june", jul =
  "july", aug = "august", sep = "september", oct = "october", nov = "november",
  dec = "december"))
}
\arguments{
\item{d}{(\code{character}) The date to be converted.}

\item{asDate}{(\code{boolean}) Return as R "\code{Date}" representation (TRUE) or 
as character string (FALSE).}

\item{months}{(\code{object}) The name of the year's month.}
}
\value{
(see Parameter \code{asDate}) Reformatted date.
}
\description{
This method reformats a date string for R packages as these can be very heterogenous defined
in the DESCRIPTION files of packages.
}
\examples{

new_date <- normalizeDate("15.September.2018",FALSE)

stopifnot(new_date=="15.09.2018")

}
\seealso{
\code{\link{as.Date}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
