% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transForecast_mnl.R
\name{transForecast_mnl}
\alias{transForecast_mnl}
\title{Forecast - using Multinomial Logistic Regression}
\usage{
transForecast_mnl(data, histData, predData_mnl, startDate, endDate, method, 
                         interval,snapshots, defind,ref, depVar, indVars, ratingCat, wgt)
}
\arguments{
\item{data}{a table containing historical credit ratings data (i.e., credit migration data). A dataframe of size \emph{nRecords} x 3 where each row contains an ID (column 1), a date (column 2), and a credit rating (column 3); The credit rating is the rating assigned to the corresponding ID on the corresponding date.}

\item{histData}{historical macroeconomic,financial and non-financial data.}

\item{predData_mnl}{forecasting data.}

\item{startDate}{start date of the estimation time window, in string or numeric format.}

\item{endDate}{end date of the estimation time window, in string or numeric format.}

\item{method}{estimation algorithm, in string format. Valid values are 'duration'  or 'cohort'.}

\item{interval}{the length of the transition interval under consideration, in years. The default value is 1, \emph{i.e., 1-year transition probabilities are estimated}.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{defind}{Default Indicator}

\item{ref}{base or reference category for the dependent variable.}

\item{depVar}{dependent variable, as a string.}

\item{indVars}{list containing the independent variables}

\item{ratingCat}{list containing the unique rating categories}

\item{wgt}{weights}
}
\value{
The output consists of a forecasted transition matrix.
}
\description{
This model implements a forecasting method using multinomial logistic regression (also known as Softmax Regression in machine learning parlance).
}
\details{
Multinomial logistic regression is a simple extension of binary logistic regression that allows for more than two categories of
the dependent or outcome variable.  Whereas, a binary logistic regression model compares one dichotomy, the multinomial logistic
regression model compares a number of dichotomies. Like binary logistic regression, multinomial logistic regression uses maximum
likelihood estimation to evaluate the probability of categorical membership.

Assume there are 1,2,3 ...K groups in a dataset, and group 1 is the one chosen as the reference category. The logistic model states
that the probability of falling into group j given the set of predictor values x is given by the general expression
\deqn{P(y=k|\emph{X}) = \frac{exp(\emph{X}\beta_{k})}{1+\sum_{j=2}^{N}exp(\emph{X}\beta_{j})}}
}
\examples{
\dontrun{
mnl_TM<-transForecast_mnl(data, histData, predData_mnl, startDate, endDate, method, interval,  
                         snapshots, defind, ref, depVar,indVars, ratingCat, wgt)
}


}
\author{
Abdoulaye (Ab) N'Diaye
}
