% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transForecast_svm.R
\name{transForecast_svm}
\alias{transForecast_svm}
\title{Forecast - using Support Vector Machines}
\usage{
transForecast_svm(data, histData, predData_svm, startDate, endDate,
                    method, interval, snapshots, defind, depVar, indVars,  ratingCat, 
                    pct, tuning, kernelType, cost, cost.weights, gamma, gamma.weights)
}
\arguments{
\item{data}{a table containing historical credit ratings data (i.e., credit migration data). A dataframe of size \emph{nRecords} x 3 where each row contains an ID (column 1), a date (column 2), and a credit rating (column 3); The credit rating is the rating assigned to the corresponding ID on the corresponding date.}

\item{histData}{historical macroeconomic,financial and non-financial data.}

\item{predData_svm}{forecasting data.}

\item{startDate}{start date of the estimation time window, in string or numeric format.}

\item{endDate}{end date of the estimation time window, in string or numeric format.}

\item{method}{estimation algorithm, in string format. Valid values are 'duration'  or 'cohort'.}

\item{interval}{the length of the transition interval under consideration, in years. The default value is 1, \emph{i.e., 1-year transition probabilities are estimated}.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{defind}{Default Indicator}

\item{depVar}{dependent variable, as a string.}

\item{indVars}{list containing the independent variables.}

\item{ratingCat}{list containing the unique rating caetgories}

\item{pct}{percent of data used in training dataset.}

\item{tuning}{perform tuning. If tuning='TRUE' tuning is perform. If tuning='FALSE' tuning is not performed}

\item{kernelType}{the kernel used in training and predicting (see Package e1071 for more detail)}

\item{cost}{cost of constraints violation (default: 1) it is the 'C' constant of the regularization term in the Lagrange formulation.}

\item{cost.weights}{vector containing tuning parameters for cost}

\item{gamma}{parameter needed for all kernels except linear (default: 1/(data dimension))}

\item{gamma.weights}{vector containing tuning parameters for gamma}
}
\value{
The output consists of a forecasted transition matrix using SVM.
}
\description{
This model implements a forecasting method using Support Vector Machines.
}
\examples{
\dontrun{
library(dplyr)
library(plyr)
library(Matrix)
library(tictoc)



for (i in c(24, 25, 26)) {
 print(paste("RUN-",i,sep=""))
 data <- data
 
 histData <- histData.normz
 
 
 predData_svm2 <- predData_svm_Baseline
 predData_svm2 <- subset(
   predData_svm2,
   X == i,
   select = c(Market.Volatility.Index..Level..normz

   )
 )
 
 indVars   = c("Market.Volatility.Index..Level..normz"

 )
 
 
 startDate = "1991-08-16"
 endDate   = "2007-08-16"
 
 depVar <- c("end_rating")
 
 pct <- 1
 wgt <-  "mCount"
 ratingCat <- c("A", "B", "C", "D", "E", "F", "G")
 defind    <- "G"
 lstCategoricalVars <- c("end_rating")
 tuning <- "FALSE"
 cost <- 0.01
 gamma <- 0.01
 cost.weights <-  c(0.01, 0.05, 0.1, 0.25, 10, 50, 100)
 gamma.weights <- c(0.01, 0.05, 0.1, 0.25, 10, 50, 100)
 kernelType <- "sigmoid"
 method    = "cohort"
 snapshots = 1
 interval  = 1
 
 
 svm_TM <-
   transForecast_svm(
     data,
     histData,
     predData_svm2,
     startDate,
     endDate,
     method,
     interval,
     snapshots,
     defind,
     depVar,
     indVars,
     ratingCat,
     pct,
     tuning,
     kernelType,
     cost,
     cost.weights,
     gamma,
     gamma.weights
   )
 print(svm_TM)
 
}
}
}
\author{
Abdoulaye (Ab) N'Diaye
}
