\name{eff.theo}
\alias{eff.theo}
\title{
Conformite de plusieurs proportions avec des valeurs theoriques - effectifs theoriques
}
\description{
Renvoie un tableau de contingence des effectifs thoriques dans le cadre d'un test de comparaison de plusieurs proportions avec des valeurs thoriques.
}
\usage{
eff.theo(data, p.theo, graphe = FALSE)
}
\arguments{
  \item{data}{
tableau de contingence des effectifs tests.
}
  \item{p.theo}{
proportions thoriques.
}
  \item{graphe}{
logique : si \code{TRUE} le graphe reprsentant le tableau de contingence des effectifs thoriques est trac.
}
}
\details{
Le tableau de contingence des effectifs tests doit avoir en lignes les populations (statistiques)  comparer et en colonnes les deux classess de la variable dfinissant les proportions.  La colonne de gauche est utilise pour calculer les proportions testes.

Le tableau de contingence des effectifs thoriques a la mme structure que le tableau des effectifs tests.

La fonction renvoie le nombre de cases du tableau des effectifs thoriques qui peuvent avoir une valeur infrieure ou gale  5 pour que la rgle de Cochran soit respecte.  Cette rgle dit qu'au moins 80 \% des cases doivent avoir un effectif thorique suprieur ou gal  5.
}
\author{
Maxime Herv
}
\seealso{
\code{\link{prop.test}}, \code{\link{chisq.test}}, \code{\link{mosaicplot}}
}
\examples{
# Pas de graphe trace (fonctionnement par defaut)
pop<-sample(LETTERS[1:3],60,replace=TRUE)
prop<-sample(c(0,1),60,replace=TRUE)
tab.cont<-table(pop,prop)
prop.theo<-c(0.2,0.5,0.7)
eff.theo(tab.cont,p.theo=prop.theo)

# Avec une representation graphique du tableau des effectifs theoriques
eff.theo(tab.cont,p.theo=prop.theo,graphe=TRUE)
}
