\name{least.rect}
\alias{least.rect}
\title{
Regression lineaire simple au sens des moindres rectangles
}
\description{
Renvoie un rsum d'une rgression linaire simple au sens des moindres rectangles,  la manire du rsum renvoy par \code{summary(lm())} pour une rgression au sens des moindres carrs.
}
\usage{
least.rect(x, y, conf.level = 0.95, theo = 1, coeff.arr = 4, p.arr = 4)
}
\arguments{
  \item{x}{
1re variable de la rgression.
}
  \item{y}{
2me variable de la rgression.
}
  \item{conf.level}{
intervalle de confiance des paramtres de la droite de rgression.
}
  \item{theo}{
valeur thorique pour le test de conformit du coefficient directeur de la droite de rgression.
}
  \item{coeff.arr}{
nombre de dcimales affiches pour les coefficients et leur intervalle de confiance.
}
  \item{p.arr}{
nombre de dcimales affiches pour les \emph{p-values} des tests raliss.
}
}
\details{
Les noms \code{x} et \code{y} n'ont qu'une valeur graphique (\code{x} : variable destine  tre trace en abscisses ; \code{y} : variable destine  tre trace en ordonnes).  Ils ne font pas rfrence  une variable explicative et une  expliquer.

La fonction renvoie : l'quation de la droite de rgression, l'intervalle de confiance des paramtres de la droite (coefficient directeur et ordonne  l'origine), le rsultat du test de conformit du coefficient directeur avec une valeur thorique choisie et enfin le coefficient de corrlation linaire entre les deux variables, son intervalle de confiance et le rsultat du test de significativit.
}
\author{
Maxime Herv
}
\seealso{
\code{\link{cor.test}}
}
\examples{
# Resume par defaut
x<-1:30+rnorm(30,0,3)
y<-1:30+rnorm(30,0,3)
least.rect(x,y)

# Conformite du coefficient directeur avec la valeur 0.5
# et intervalles de confiance a 99 pc
least.rect(x,y,conf.level=0.99,theo=0.5)
}
