% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVenn.R, R/Enrichment.R
\docType{methods}
\name{enrichment_test}
\alias{enrichment_test}
\alias{enrichment_test,Venn-method}
\title{Perform an enrichment test.}
\usage{
\S4method{enrichment_test}{Venn}(venn, set1, set2, univ = "all",
  n = 10000, seed = 42)
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{set1}{(Required) The name or the index of the set of interest.}

\item{set2}{(Required) The name or the index of the set to be checked whether
enriched in \code{set1}.}

\item{univ}{(Optional) Population size. Default is "all", implying the union
of all the sets in the \code{Venn} object will be used. Another set as the
whole population can be assigned as well.}

\item{n}{(Optional) Number of randomly generated sets. Default is 10,000 and
minimum is 1,000.}

\item{seed}{(Optional) An integer passed to set.seed function. It is
used to fix a seed for reproducibly random number generation. Default is
42.}
}
\value{
Returns a list containing the probability (Significance) of occurrence
  of an overlap between two sets by chance and the number of occurrences
  (Overlap_Counts) in randomly generated sets.
}
\description{
Calculate the p-value of occurrence of an overlap between two sets by chance.
}
\details{
This type of analysis can also be performed by hypergeometric test or
Fisher's exact test. Here, the approach is similar to that described in
(\href{https://onlinelibrary.wiley.com/doi/full/10.1111/tpj.13261}{Austin et
al., 2016}). Briefly, the test is based on randomly generation of sets with
equal size to \code{set1} from the background (universal) set. After creating
n (default is 10,000) random sets, the overlap between these and \code{set2}
is calculated to make a null distribution. When this distribution is true,
the probability of seeing an overlap at least as extreme as what was observed
(overlap between \code{set1} and \code{set2}) will be returned as the
p-value.
}
\examples{
set1 = c(1:20, letters[1:10])
set2 = letters[-26]
univ = unique(c(set1, set2, 21:200))
venn = Venn(list(set1, set2, univ))
e = enrichment_test(venn, 1, 2)
e$Significance
}
