/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Environment;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="SetVariables", category="Flow", toolTipText="Assign default values for variables if they are not already set", iconPath="weka/gui/knowledgeflow/icons/DiamondPlain.gif")
public class SetVariables
extends BaseStep {
    public static final String SEP1 = "@@vv@@";
    public static final String SEP2 = "@v@v";
    private static final long serialVersionUID = 8042350408846800738L;
    protected String m_internalRep = "";
    protected Map<String, String> m_varsToSet = new LinkedHashMap<String, String>();

    @ProgrammaticProperty
    public void setVarsInternalRep(String rep) {
        this.m_internalRep = rep;
    }

    public String getVarsInternalRep() {
        return this.m_internalRep;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_varsToSet = SetVariables.internalToMap(this.m_internalRep);
        Environment currentEnv = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (currentEnv == null) {
            throw new WekaException("The execution environment doesn't seem to have any support for variables");
        }
        for (Map.Entry<String, String> e : this.m_varsToSet.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key == null || key.length() <= 0 || value == null || currentEnv.getVariableValue(key) != null) continue;
            this.getStepManager().logDetailed("Setting variable: " + key + " = " + value);
            currentEnv.addVariable(key, value);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return new ArrayList<String>();
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.SetVariablesStepEditorDialog";
    }

    public static Map<String, String> internalToMap(String internalRep) {
        LinkedHashMap<String, String> varsToSet = new LinkedHashMap<String, String>();
        if (internalRep != null || internalRep.length() > 0) {
            String[] parts;
            for (String p : parts = internalRep.split(SEP1)) {
                String[] keyVal = p.trim().split(SEP2);
                if (keyVal.length != 2) continue;
                varsToSet.put(keyVal[0].trim(), keyVal[1]);
            }
        }
        return varsToSet;
    }
}

