/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ScriptUtils {
    protected static void copyOrMove(File sourceLocation, File targetLocation, boolean move) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                ScriptUtils.copyOrMove(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), move);
            }
            if (move) {
                sourceLocation.delete();
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = targetLocation.isDirectory() ? new FileOutputStream(targetLocation.getAbsolutePath() + File.separator + sourceLocation.getName()) : new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            if (move) {
                sourceLocation.delete();
            }
        }
    }

    public static void copy(File sourceLocation, File targetLocation) throws IOException {
        ScriptUtils.copyOrMove(sourceLocation, targetLocation, false);
    }

    public static void move(File sourceLocation, File targetLocation) throws IOException {
        ScriptUtils.copyOrMove(sourceLocation, targetLocation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(File file, String content) {
        boolean result;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(content);
            writer.flush();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(File file) {
        StringBuffer result = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append(newLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return result != null ? result.toString() : null;
    }
}

