% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotDiffNoise}
\alias{plotDiffNoise}
\title{Function for plotting differentially variable genes}
\usage{
plotDiffNoise(
  x,
  pthr = 0.05,
  mu = TRUE,
  lthr = 0,
  ps = 0.01,
  mthr = -Inf,
  set.name = NULL,
  bgr.name = NULL,
  show_names = TRUE
)
}
\arguments{
\item{x}{output of the function \code{diffNoisyGenesTB}.}

\item{pthr}{real number between 0 and 1. This number represents the p-value cutoff applied for displaying differentially variable genes. Default value is 0.05.}

\item{mu}{logical value. If \code{TRUE} then the log2 fold change in variability is plotted as a function of log2 average expresion. Otherwise, it is plotted as a function of mean variability.}

\item{lthr}{real number between 0 and Inf. Differentially variable genes are displayed only for log2 fold-changes greater than \code{lthr}. Default value is 0.}

\item{ps}{positive real number. Pseudo-count added to component \code{mu.all} and \code{epsilon.all} of argument \code{x} to avoid taking logarithm of zero. Default is 0.01.}

\item{mthr}{real number between -Inf and Inf. Differentially variable genes are displayed only for log2 mean expression (or mean noise, if \code{mu} equals \code{FALSE}) greater than \code{mthr}. Default value is -Inf.}

\item{set.name}{name of \code{set}, which was used as input to \code{diffNoisyGenesTB}. If provided, this name is used in the axis labels. Default value is \code{NULL}.}

\item{bgr.name}{name of \code{bgr}, which was used as input to \code{diffNoisyGenesTB}. If provided, this name is used in the axis labels. Default value is \code{NULL}.}

\item{show_names}{logical value. If \code{TRUE} then gene names displayed for differentially variable genes. Default value is \code{FALSE}.}
}
\value{
None
}
\description{
This is a plotting function for visualizing the output of the \code{diffNoisyGenesTB} function as MA plot.
}
