% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{convert_snake_to_title_case}
\alias{convert_snake_to_title_case}
\title{Helper function to convert a snake_case string to Title Case}
\usage{
convert_snake_to_title_case(string)
}
\arguments{
\item{string}{A character string in snake_case format.}
}
\value{
A character string converted to Title Case.
}
\description{
Converts a snake_case string to Title Case.
}
\details{
This function is useful for formatting strings in a more readable
way, especially when dealing with variable names or identifiers that use
snake_case. This function takes a snake_case string and converts it to Title Case.
It replaces underscores with spaces, capitalizes the first letter of each word,
and replaces the substring "cum" with "cumulative" for better readability.
}
\examples{
convert_snake_to_title_case("hello_world") # "Hello World"
convert_snake_to_title_case("this_is_a_test") # "This Is A Test"
convert_snake_to_title_case("cumulative_sum") # "Cumulative Sum"

}
\seealso{
Other Utility Functions: 
\code{\link{confidence_interval}()},
\code{\link{generate_caption}()},
\code{\link{get_attributes}()},
\code{\link{rand_walk_column_names}()},
\code{\link{rand_walk_helper}()},
\code{\link{running_quantile}()},
\code{\link{std_cum_max_augment}()},
\code{\link{std_cum_mean_augment}()},
\code{\link{std_cum_min_augment}()},
\code{\link{std_cum_prod_augment}()},
\code{\link{std_cum_sum_augment}()}
}
\author{
Antti Lennart Rask
}
\concept{Utility Functions}
