% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subit_convergence.R
\name{subit_convergence}
\alias{subit_convergence}
\title{Subiterative Convergence}
\usage{
subit_convergence(eta, seed_rkg, input_rkgs, universe_rkgs = c())
}
\arguments{
\item{eta}{a subiteration length of number of objects to consider in the smaller
subset. Recommended \code{eta} values are between 2 and 8. Smaller \code{eta} values result in shorter run-time.}

\item{seed_rkg}{an initial ranking to start the algorithm. An ideal seed ranking for
\emph{Subiterative Convergence} is the \emph{mean seed ranking} of input rankings.}

\item{input_rkgs}{a \code{n} by \code{k} matrix of \code{k} rankings of \code{n}
objects, where each column is a complete ranking.}

\item{universe_rkgs}{a matrix containing all possible permutations of ranking
\code{n} objects. Each column in this matrix represents one permuted ranking.}
}
\value{
A list containing the consensus ranking (expressed as ordering), total Kemeny distance, and average
tau correlation coefficient corresponding to the consensus ranking.
}
\description{
\emph{Subiterative Convergence} finds the consensus ranking by iteratively applying the
\emph{Modified Kemeny} algorithm on smaller number of objects, \eqn{\eta}{eta}. Starting with a given seed
ranking, the consensus ranking is obtained when the algorithm converges.
}
\examples{
## Four input rankings of five objects
eta <- 3
seed_rkg <- c(1, 2, 3, 4, 5)
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 2, 4, 5, 3),
    byrow = FALSE, ncol = 4)
subit_convergence(eta, seed_rkg, input_rkgs) # Determined the consensus ranking, total Kemeny
                                             # distance, and average tau correlation coefficient

## Example with eta=1
eta <- 1
seed_rkg <- c(1, 2, 3, 4, 5)
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 2, 4, 5, 3),
    byrow = FALSE, ncol = 4)
subit_convergence(eta, seed_rkg, input_rkgs) # Shows a warning and returns seed ranking

## Included dataset of 15 input rankings of 50 objects
data(data50x15)
input_rkgs <- as.matrix(data50x15[, -1])
mean_seed_rkg <- mean_seed(t(input_rkgs)) # Use the mean seed ranking as the seed ranking
eta <- 2
subit_convergence(eta, seed_rkg = mean_seed_rkg, input_rkgs)

}
\references{
Badal, P. S., & Das, A. (2018). Efficient algorithms using subiterative
convergence for Kemeny ranking problem. Computers & Operations Research, 98, 198-210.
\doi{10.1016/j.cor.2018.06.007}
}
\seealso{
\code{\link{mod_kemeny}}, \code{\link{fur}}, \code{\link{sigfur}}, \code{\link{mean_seed}}
}
