% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_gridweights_write.R
\name{rvn_gridweights_write}
\alias{rvn_gridweights_write}
\title{Write Raven GridWeights file}
\usage{
rvn_gridweights_write(gridweights = NULL, outfile = "GridWeights.rvt")
}
\arguments{
\item{gridweights}{list with the number of HRUs, number of grid cells, and gridweights data frame}

\item{outfile}{file to write gridweights to}
}
\value{
\item{hyd}{data frame from the file with standardized names}
}
\description{
rvn_gridweights_write is used to write a Raven grid weights file.
}
\details{
This function write the gridweights to the specified grid weights text file.
}
\examples{

# load example rvh file
nith <- system.file("extdata",'Nith.rvh', package = "RavenR")
rvh <- rvn_rvh_read(nith)

# adjust HRU shapefile to one per subbasin for demonstration
rvh$HRUtable <- rvh$HRUtable[c(1,6,15,25),]
rvh$HRUtable$Area <- rvh$SBtable$Area
rvh$HRUtable$ID <- rvh$HRUtable$SBID

# define HRU shapefile path (use subbasin shapefile for example)
hrushpfile <- system.file("extdata","Nith_shapefile_sample.shp",package = "RavenR")

# get grid shapefile from netcdf file
nithnc <- system.file("extdata/Nith_era5_sample.nc", package="RavenR")
gridshp <- rvn_netcdf_to_gridshp(ncfile=nithnc, projID=26917)

# calculate gridweights
gw <- rvn_gen_gridweights(hrushpfile, gridshp,
gridIDcol = 'GridIDs', HRUIDcol = "subID")

# write the gridweights (gw) object to file
tfout <- file.path(tempdir(), "Nith_GridWeights.rvt")
rvn_gridweights_write(gw, outfile=tfout)

}
\seealso{
\code{\link{rvn_gen_gridweights}} for generating a grid weights file from an HRU shapefile
and netcdf file.
}
