% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_flow_scatterplot.R
\name{rvn_flow_scatterplot}
\alias{rvn_flow_scatterplot}
\title{Scatterplot of model flows}
\usage{
rvn_flow_scatterplot(
  sim,
  obs,
  add_line = TRUE,
  add_r2 = FALSE,
  add_eqn = FALSE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{add_line}{optionally adds a 1:1 line to the plot for reference (default \code{TRUE})}

\item{add_r2}{optionally computes the R2 and adds to plot (default \code{FALSE})}

\item{add_eqn}{optionally adds the equation for a linear regression line (default \code{FALSE})}
}
\value{
\item{TRUE}{return \code{TRUE} if the function is executed properly}
}
\description{
rvn_flow_scatterplot creates a scatterplot of the simulated and observed flows.
Useful in diagnotic analysis of model outputs.
}
\details{
Creates a scatterplot of flows.

The sim and obs should be of time series (xts) format. The flow series are
assumed to be daily flows with units of m3/s.

The R2 diagnostic is calculated for a fit with no intercept (in a perfect
fit the points are identical, and intercept is automatically zero). The R2
is calculated with the NA values removed

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
sim <- rvn_hydrograph_data$hyd$Sub36
obs <- rvn_hydrograph_data$hyd$Sub36_ob

# plot the flow scatterplot, produce an R2 metric
rvn_flow_scatterplot(sim,obs,add_r2=TRUE)

# plot again with a regression equation
rvn_flow_scatterplot(sim,obs,add_r2=TRUE,add_eqn=TRUE)

}
\seealso{
\code{\link{rvn_forcings_read}} for reading in the ForcingFunctions
file
}
