% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{toPOSIXct}
\alias{toPOSIXct}
\title{Parse POSIXct objects from input data}
\usage{
toPOSIXct(x, tz = "UTC")
}
\arguments{
\item{x}{A vector of type character, integer or numeric with 
date(time) expressions to be parsed and converted.}

\item{tz}{A string with the timezone, defaults to \sQuote{UTC} if unset}
}
\value{
A vector of \sQuote{POSIXct} elements.
}
\description{
This function uses the Boost Date_Time library to parse 
datetimes (and dates) from strings, integers or even numeric values
(which are cast to strings internall). It returns a vector of
\code{POSIXct} objects. These represent dates and time as (possibly
fractional) seconds since the \sQuote{epoch} of January 1, 1970. 
A timezone can be set, if none is supplied \sQuote{UTC} is set.
}
\details{
A number of fixed formats are tried in succession. These include
the standard ISO format \sQuote{YYYY-MM-DD HH:MM:SS} as well as
different local variants including several forms popular in the 
United States.  Two-digits years and clearly ambigous formats such
as \sQuote{03/04/05} are ignored.  In the case of parsing failure
a \code{NA} value is returned.

Fractional seconds are supported as well.  As R itself only supports 
microseconds, the Boost compile-time option for nano-second resolution 
has not been enabled.
}
\examples{
## See the source code (hah!) for a full list of formats
times <- c("2004-03-21 12:45:33.123456",
          "2004/03/21 12:45:33.123456",
          "20040321 124533.123456",
          "21.03.2004 12:45:33.123456", 
          "03/21/2004 12:45:33.123456",
          "03-21-2004 12:45:33.123456", 
          "2004-03-21",
          "20040321",
          "03/21/2004",
          "03-21-2004",
          "20010101")   
toPOSIXct(times)
}
\seealso{
The funtion in the anytime package which is a more finished.
variant which is based on the initial work with function, and taken into
its own package.
}
\author{
Dirk Eddelbuettel
}
