% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movQt}
\alias{movQt}
\alias{movQtr}
\title{Moving Quantile(Moving Median, Moving Minimum, Moving Maximum)}
\usage{
movQt(vec, n = 1L, prob = 0.5, ss = 1L, na_rm = FALSE, sizeD = FALSE,
  align = "left")

movQtr(vec, n = 1L, prob = 0.5, ss = 1L, na_rm = FALSE, sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{n}{An integer: moving window size, with 1 as default}

\item{prob}{A number: between \emph{0} and \emph{1}, meaning \emph{prob} quantile}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns a vector whose length is the same as that of \emph{vec} or is 
\code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
length of \eqn{vec}.
}
\description{
This function returns a moving quantile of the given vector.
}
\details{
Despite of Efficient computation, this function can return different kinds of moving quantile,
e.g. moving median(\eqn{prob = 0.5}), moving minimum(\eqn{prob = 0}), 
and moving maximum(\eqn{prob = 1}). It can handle potential 
missing values(\emph{NA} or \emph{NaN}) in the \emph{vec}. When we move to one specific fragment, missing 
values can be removed by setting \eqn{na_rm = TRUERUE}. If all values of this fragment is missing, 
it will return \emph{NA}.  \cr
In terms of the quantile algorithm, please consult type \emph{7} in function 
\code{\link[stats]{quantile}}.
}
\section{Functions}{
\itemize{
\item \code{movQtr}: An function equivalent to \code{movQt(..., align = "right")}
}}

\examples{
movQt(vec = c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "right")
movQt(vec = c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, na_rm = TRUE, align = "right")
movQt(vec = c(1, 4, 3, NA, NA, NA, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "middle")
}
