% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likeParamNames.R
\name{likeParamNames}
\alias{likeParamNames}
\title{Likelihood parameter names}
\usage{
likeParamNames(like.form)
}
\arguments{
\item{like.form}{A text string naming the form of the likelihood.}
}
\value{
A vector of parameter names for that likelihood
}
\description{
Returns names of the likelihood parameters. This is 
a helper function and is not
necessary for estimation.  It is a nice to label some 
outputs in \code{Rdistance} with 
parameter names like "sigma" or "knee", depending on the likelihood, 
and this routine provides a way to do that.
}
\details{
For user defined functions, ensure that the 
user defined start-limits function named <likelihood>.start.limits
can be evaluated on a distance of 1, can accept 0 expansions, 
a low limit of 0 
a high limit of 1, and that it returns the parameter names as 
the \code{$names} component of the result. That is, the 
code that returns user-defined parameter names is, 
\code{fn <- match.fun( paste0(like.form, ".start.limits"));
ans <- fn(1, 0, 0, 1);
ans$names}
}
