% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_reaction_vector.R
\name{check_matrix}
\alias{check_matrix}
\title{check_matrix()}
\usage{
check_matrix(input_mat, rxy)
}
\arguments{
\item{input_mat}{This is the user-defined stoichiometry matrix of a generic
metabolic network and is a mandatory argument.}

\item{rxy}{A mandatory logical argument that indicates the orientation of
reactions as rows (TRUE) or columns (FALSE) of the user-defined stoichiometry
matrix.}
}
\value{
output_mat A checked and modified version of the stoichiometry matrix
which is returned for further computations.

flag An indicator of the suitability of the user-defined input
stoichiometry matrix for further computations.
}
\description{
This function of the package 'ReDirection' checks whether the user-defined
stoichiometry matrix is suitable for further processing.
}
\details{
'ReDirection', is reaction-centric. This means that the computations and results
are solely based on the reactions. The number of unique reactions must exceed
the number of reactants (reactions >= reactants + 2).

Additionally, 'ReDirection' must know if the reactions are represented as
rows (TRUE) or columns (FALSE).

'ReDirection', also checks for linear dependence (rows, columns) and removes
the same. This can perturb the indices of the matrix and users are advised to
check the input stoichiometry matrix a priori.

The checked and modified matrix is returned and processed further.
}
