% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_to_rga.R
\name{weibull_to_rga}
\alias{weibull_to_rga}
\title{Weibull to RGA}
\usage{
weibull_to_rga(
  failures,
  suspensions = NULL,
  interval_starts = NULL,
  interval_ends = NULL
)
}
\arguments{
\item{failures}{A numeric vector of exact failure times.}

\item{suspensions}{A numeric vector of suspension (right-censored) times.}

\item{interval_starts}{A numeric vector of interval start times (lower bound of censoring).}

\item{interval_ends}{A numeric vector of interval end times (upper bound of censoring).}
}
\value{
A data frame with cumulative time and failure counts suitable for RGA.
}
\description{
Converts Weibull data (failure, suspension, and interval-censored times)
into a format suitable for reliability growth analysis (RGA).
}
\examples{
failures <- c(100, 200, 200, 400)
suspensions <- c(250, 350, 450)
interval_starts <- c(150, 300)
interval_ends <- c(180, 320)
result <- weibull_to_rga(failures, suspensions, interval_starts, interval_ends)
print(result)
}
