\name{stenv}
\alias{stenv}
\title{Fit the simultaneous envelope model}
\description{
 Fit the simultaneous envelope model in multivariate linear regression with dimension (q, u). 
}
\usage{
stenv(X, Y, q, u, asy = TRUE, Pinit = NULL, Ginit = NULL)
}
\arguments{
  \item{X}{Predictors. An n by p matrix, p is the number of predictors. The predictors can be univariate or multivariate, discrete or continuous.}
  \item{Y}{Multivariate responses. An n by r matrix, r is the number of responses and n is number of observations. The responses must be continuous variables.}
  \item{q}{Dimension of the X-envelope. An integer between 0 and p.}
  \item{u}{Dimension of the Y-envelope. An integer between 0 and r.}
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{Pinit}{The user-specified value of Phi for the X-envelope subspace. An p by q matrix. The default is the one generated by function stenvMU.}
  \item{Ginit}{The user-specified value of Gamma for the Y-envelope subspace. An r by u matrix. The default is the one generated by function stenvMU.}

}
\details{
 This function fits the envelope model to the responses and predictors simultaneously, \deqn{
 Y = \mu + \Gamma\eta'\Phi' X+\varepsilon, \Sigma_{Y|X}=\Gamma\Omega\Gamma'+\Gamma_{0}\Omega_{0}\Gamma'_{0}, \Sigma_{X}=\Phi\Delta\Phi'+\Phi_{0}\Delta_{0}\Phi'_{0}
 }
 using the maximum likelihood estimation.  When the dimension of the Y-envelope is between 1 and r-1 and the dimension of the X-envelope is between 1 and p-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is (p, r), then the envelope model degenerates to the standard multivariate linear regression.  When the dimension of the Y-envelope is r, then the envelope model degenerates to the standard envelope model.  When the dimension of X-envelope is p, then the envelope model degenerates to the envelope model in the predictor space.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different.
}
\value{The output is a list that contains the following components:
\item{beta}{The envelope estimator of the regression coefficients.} 
\item{SigmaYcX}{The envelope estimator of the error covariance matrix.}
\item{SigmaX}{The envelope estimator of the covariance matrix of X.}
\item{Gamma}{An orthonormal basis of the Y-envelope subspace.}
\item{Gamma0}{An orthonormal basis of the complement of the Y-envelope subspace.}
\item{eta}{The coordinates of beta with respect to Gamma and Phi.}
\item{Omega}{The coordinates of SigmaYcX with respect to Gamma.}
\item{Omega0}{The coordinates of SigmaYcX with respect to Gamma0.}
\item{mu}{The estimated intercept.}
\item{Phi}{An orthonormal basis of the X-envelope subspace.}
\item{Phi0}{An orthonormal basis of the complement of the X-envelope subspace.}
\item{Delta}{The coordinates of SigmaX with respect to Phi.}
\item{Delta0}{The coordinates of SigmaX with respect to Phi0.}
\item{loglik}{The maximized log likelihood function.}
\item{covMatrix}{The asymptotic covariance of vec(beta). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.}
\item{asySE}{The asymptotic standard error for elements in beta under the envelope model.  The standard errors returned are asymptotic, for actual standard errors, multiply by 1 / sqrt(n).}
\item{ratio}{The asymptotic standard error ratio of the standard multivariate linear regression estimator over the envelope estimator, for each element in beta.}
\item{n}{The number of observations in the data.}
}
\references{
Cook, R. D., Zhang, X. (2015). Simultaneous Envelopes for Multivariate Linear Regression. Technometrics 57, 11 - 25.

Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(fiberpaper)
X <- fiberpaper[, 5:7]
Y <- fiberpaper[, 1:4]
u <- u.stenv(X, Y)
u

m <- stenv(X, Y, 2, 3)
m
m$beta
}

