test_that("Output of function 'pReplicate' stays the same.", {
    # set all possible parameters
    grid <- expand.grid(
        zo = seq(-4, 4, length.out = 5L),
        c = c(0.001, 1, 3, 10),
        alternative = c("one.sided", "two.sided"),
        stringsAsFactors = FALSE
    )
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            tryCatch({
                pReplicate(
                    zo = grid[i, "zo"],
                    c = grid[i, "c"],
                    alternative = grid[i, "alternative"],
                )
            },
            warning = function(w) "warning!",
            error = function(e) "error!"
            )
        }
    )
    res <- list(0.44969660590343, 0.474798066609641, 0.5, 0.525201933390359,
                0.55030339409657, 0.00233886749052363, 0.0786496035251426,
                0.5, 0.921350396474857, 0.997661132509476, 0.000266002752569625,
                0.0416322583317752, 0.5, 0.958367741668225, 0.99973399724743,
                6.84091658136964e-05, 0.0282651385837021, 0.5, 0.971734861416298,
                0.999931590834186, 0.44969660590343, 0.474798066609641, 0.5,
                0.525201933390359, 0.55030339409657, 0.00233886749052363,
                0.0786496035251426, 0.5, 0.921350396474857, 0.997661132509476,
                0.000266002752569625, 0.0416322583317752, 0.5, 0.958367741668225,
                0.99973399724743, 6.84091658136964e-05, 0.0282651385837021,
                0.5, 0.971734861416298, 0.999931590834186)
    expect_equal(out, res)
})
