% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTitle.R
\name{addTitle}
\alias{addTitle}
\alias{addTitle.docx}
\alias{addTitle.pptx}
\alias{addTitle.bsdoc}
\title{Add a title into a document object}
\usage{
addTitle(doc, value, ...)

\method{addTitle}{docx}(doc, value, level = 1, ...)

\method{addTitle}{pptx}(doc, value, ...)

\method{addTitle}{bsdoc}(doc, value, level = 1, id, ...)
}
\arguments{
\item{doc}{document object}

\item{value}{\code{"character"} value to use as title text}

\item{...}{further arguments passed to or from other methods..}

\item{level}{\code{"integer"} positive value to use as
heading level. 1 for title1, 2 for title2, etc. Default to 1.}

\item{id}{\code{character} single and unique value to use as
title id when doc is \code{bsdoc}.}
}
\value{
a document object
}
\description{
Add a title into a document object
}
\details{
In MS Word, you can use whatever style you want as title formatting style.
But to be considered as entries for a Table of Content, used styles must be 'title' styles.
Theses are always available in MS Word list styles.
When template is read, ReporteRs try to guess what are theses styles.

In MS PowerPoint, level can not be used as there is no associated
level with a title in a slide.
}
\examples{

# Title example for MS Word -------
doc.filename = "ex_add_title.docx"

options( "ReporteRs-fontsize" = 10 )
doc <- docx( )

doc = addTitle( doc, "Title example 1", level = 1 )

doc = addTitle( doc, "Title example 2", level = 1 )

writeDoc( doc, file = doc.filename )

# Title example for PowerPoint -------
doc.filename = "ex_add_title.pptx"

options( "ReporteRs-fontsize" = 24 )
doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )

writeDoc( doc, file = doc.filename )
}
\seealso{
\code{\link{docx}}, \code{\link{pptx}}, \code{\link{bsdoc}}
}

