% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPlot.R
\name{addPlot}
\alias{addPlot}
\alias{addPlot.docx}
\alias{addPlot.pptx}
\title{Add a plot into a document object}
\usage{
addPlot(doc, fun, pointsize = 12, vector.graphic = FALSE, ...)

\method{addPlot}{docx}(doc, fun, pointsize = getOption("ReporteRs-fontsize"),
  vector.graphic = FALSE, width = 6, height = 6,
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  editable = TRUE, bookmark, par.properties = parProperties(text.align =
  "center", padding = 5), bg = "transparent", ...)

\method{addPlot}{pptx}(doc, fun, pointsize = 11, vector.graphic = TRUE,
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  editable = TRUE, offx, offy, width, height, bg = "transparent", ...)
}
\arguments{
\item{doc}{document object}

\item{fun}{plot function. The function will be executed to produce graphics.
For \code{grid} or \code{lattice} or \code{ggplot} object, the function
should just be \code{print} and an extra argument \code{x} should specify the object
to plot. For traditionnal plots, the function should contain plot instructions. See examples.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12 pixels.}

\item{vector.graphic}{logical scalar, if TRUE, vector graphics are
produced instead, PNG images if FALSE.}

\item{...}{further arguments passed to or from other methods. See details.}

\item{width}{plot width in inches (default value is 6).}

\item{height}{plot height in inches (default value is 6).}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font
names for font faces. Use fonts available on operating system.}

\item{editable}{logical value - if TRUE vector graphics elements (points, text, etc.) are editable.}

\item{bookmark}{id of the Word bookmark to replace by the plot. optional.

\code{bookmark} is a character vector specifying bookmark id to replace by the plot(s).\cr
      If provided, plot(s) will replace the paragraph that contains the bookmark.\cr
      If not provided, plot(s) will be added at the end of the document.}

\item{par.properties}{paragraph formatting properties of the paragraph that contains plot(s).
An object of class \code{\link{parProperties}}}

\item{bg}{the initial background colour.}

\item{offx, offy}{optional. x and y position of the shape (left top position of the bounding box) in inches. See details.}
}
\value{
a document object
}
\description{
Add a plot into a document object
}
\details{
Plot parameters are specified with the \code{...} argument.
However, the most convenient usage is to wrap the plot code
into a function whose parameters will be specified as '...'.

If you want to add ggplot2 or lattice plot, use \code{print} function.

\code{vector.graphic}: DrawingML instructions will be produced
for \code{docx} and \code{pptx} objects.
Don't use vector graphics if document is a docx and MS Word version
used to open the document is 2007.

When document is a \code{pptx} object, two positioning methods are available.

If arguments offx, offy, width, height are missing, position and dimensions
will be defined by the width and height of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint template used to create
the \code{pptx} object.

If arguments offx, offy, width, height are provided, they become position and
dimensions of the new shape.
}
\examples{

is_sunos <- tolower(Sys.info()[["sysname"]]) == "sunos"

options( "ReporteRs-fontsize" = 11 )


# plot example for docx -----
\donttest{
doc = docx( )
doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 7,
  par.properties = parProperties(text.align = "center")
  )
writeDoc( doc, file = "ex_plot.docx" )
}


# plot example for pptx -----
\donttest{
doc = pptx( )
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 4 )
if( !is_sunos ){
  doc = addPlot( doc,
    fun = function() barplot( 1:6, col = 2:7),
    vector.graphic = FALSE,
    offx = 7, offy = 0,
    width = 3, height = 2
    )
}

writeDoc( doc, file = "ex_plot.pptx" )
}

}
\seealso{
\code{\link{docx}}, \code{\link{pptx}}
}

