% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{reporter_score}
\alias{reporter_score}
\alias{GRSA}
\alias{RSA}
\title{One step to get the reporter score of your KO abundance table.}
\usage{
reporter_score(
  kodf,
  group,
  metadata = NULL,
  method = "wilcox.test",
  pattern = NULL,
  p.adjust.method1 = "none",
  mode = c("directed", "mixed")[1],
  verbose = TRUE,
  feature = "ko",
  type = c("pathway", "module")[1],
  p.adjust.method2 = "BH",
  modulelist = NULL,
  threads = 1,
  perm = 4999,
  min_exist_KO = 3,
  max_exist_KO = 600
)
}
\arguments{
\item{kodf}{KO_abundance table, rowname are feature ids (e.g. K00001 if feature="ko"; PEX11A if feature="gene"; C00024 if feature="compound"), colnames are samples.}

\item{group}{The comparison groups (at least two categories) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of kodf. And you can use factor levels to change order.}

\item{metadata}{sample information data.frame contains group}

\item{method}{the type of test. Default is `wilcox.test`. Allowed values include:
\itemize{
\item \code{\link[stats]{t.test}} (parametric) and \code{\link[stats]{wilcox.test}} (non-parametric). Perform comparison between two groups of samples. If the grouping variable contains more than two levels, then a pairwise comparison is performed.
\item \code{\link[stats]{anova}} (parametric) and \code{\link[stats]{kruskal.test}} (non-parametric). Perform one-way ANOVA test comparing multiple groups.
\item 'pearson', 'kendall', or 'spearman' (correlation), see \code{\link[stats]{cor}}.}}

\item{pattern}{a named vector matching the group, e.g. c('G1'=1,'G2'=3,'G3'=2), use the correlation analysis with specific pattern to calculate p-value.}

\item{p.adjust.method1}{p.adjust.method for `ko.test`, see \code{\link[stats]{p.adjust}}}

\item{mode}{'mixed' or 'directed' (default, only for two groups differential analysis or multi-groups correlation analysis.), see details in \code{\link{pvalue2zs}}.}

\item{verbose}{logical}

\item{feature}{one of 'ko', 'gene', 'compound'}

\item{type}{'pathway' or 'module' for default KOlist for microbiome, 'CC', 'MF', 'BP', 'ALL' for default GOlist for homo sapiens. And org in listed in 'https://www.genome.jp/kegg/catalog/org_list.html' such as 'hsa' (if your kodf is come from a specific organism, you should specify type here).}

\item{p.adjust.method2}{p.adjust.method for the correction of ReporterScore, see \code{\link[stats]{p.adjust}}}

\item{modulelist}{NULL or customized modulelist dataframe, must contain 'id','K_num','KOs','Description' columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{threads}{default 1}

\item{perm}{permutation number, default: 4999.}

\item{min_exist_KO}{min exist KO number in a pathway (default, 3, when a pathway contains KOs less than 3, there will be no RS)}

\item{max_exist_KO}{max exist KO number in a pathway (default, 600, when a pathway contains KOs more than 600, there will be no RS)}
}
\value{
reporter_score object:
\item{kodf}{your input KO_abundance table}
\item{ko_stat}{ko statistics result contains p.value and z_score}
\item{reporter_s}{the reporter score in each pathway}
\item{modulelist}{default KOlist or customized modulelist dataframe}
\item{group}{The comparison groups in your data}
\item{metadata}{sample information dataframe contains group}

for the `reporter_s` in result, whose columns represent:
\item{ID}{pathway id}
\item{Description}{pathway description}
\item{K_num}{total number of KOs/genes in the pathway}
\item{Exist_K_num}{number of KOs/genes in your inputdata that exist in the pathway}
\item{Significant_K_num}{number of kos/genes in your inputdata that are significant in the pathway}
\item{Z_score}{\eqn{Z_{pathway}=\frac{1}{\sqrt{k}}\sum Z_{koi}}}
\item{BG_Mean}{Background mean, \eqn{\mu _k}}
\item{BG_Sd}{Background standard deviation, \eqn{\sigma _k}}
\item{ReporterScore}{ReporterScore of the pathway, \eqn{ReporterScore=(Z_{pathway}-\mu _k)/\sigma _k}}
\item{p.value}{p.value of the ReporterScore}
\item{p.adjust}{adjusted p.value by p.adjust.method2}
}
\description{
One step to get the reporter score of your KO abundance table.
}
\examples{
message("The following example require some time to run:")
\donttest{
data("KO_abundance_test")
reporter_score_res <- reporter_score(KO_abundance, "Group", metadata,
  mode = "directed", perm = 499
)
head(reporter_score_res$reporter_s)
reporter_score_res2 <- reporter_score(KO_abundance, "Group2", metadata,
  mode = "mixed",
  method = "kruskal.test", p.adjust.method1 = "none", perm = 499
)
reporter_score_res3 <- reporter_score(KO_abundance, "Group2", metadata,
  mode = "directed",
  method = "pearson", pattern = c("G1" = 1, "G2" = 3, "G3" = 2), perm = 499
)
}
}
\seealso{
Other GRSA: 
\code{\link{combine_rs_res}()},
\code{\link{get_reporter_score}()},
\code{\link{ko.test}()},
\code{\link{pvalue2zs}()}
}
\concept{GRSA}
