//Author: Manos Papadakis

// This file was generated by compileAttributes
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppArmadillo.h>
#include <vector>

using namespace Rcpp;
using namespace std;

//[[Rcpp::export]]
vector<double> upper_tri(NumericMatrix x){
  const int ncl=x.ncol(),nrw=x.nrow();
  int i,j;
  vector<double> f;
  if(ncl>nrw)
  	f.resize(ncl*(nrw-1)*0.5);
  else 
  	f.resize(nrw*(nrw-1)*0.5);
  vector<double>::iterator ff=f.begin();
  for(i=1;i<ncl;++i)
    for(j=0;j<i;++j,++ff)
        *ff=x(j,i);
  return f;
}


double sum_upper_tri(NumericMatrix x){
  const int ncl=x.ncol();
  int i,j;
  double s=0.0;
  for(i=1;i<ncl;++i)
    for(j=0;j<i;++j)
        s+=x(j,i);
  return s;
}


//[[Rcpp::export]]
LogicalMatrix upper_tri_b(int nrw, int ncl){
  int i,j;
  LogicalMatrix f(nrw,ncl);
  for(i=1;i<ncl;++i)
    for(j=0;j<i;++j)
      f(j,i)=true;
  return f;
}

RcppExport SEXP Rfast_upper_tri(SEXP xSEXP){
BEGIN_RCPP
    RObject __result;
    RNGScope __rngScope;
    traits::input_parameter< NumericMatrix >::type x(xSEXP);
    __result = wrap(upper_tri(x));
    return __result;
END_RCPP
}

RcppExport SEXP Rfast_upper_tri_b(SEXP nclSEXP, SEXP nrwSEXP){
BEGIN_RCPP
    RObject __result;
    RNGScope __rngScope;
    traits::input_parameter< int >::type ncl(nclSEXP);
    traits::input_parameter< int >::type nrw(nrwSEXP);
    __result = wrap(upper_tri_b(nrw,ncl));
    return __result;
END_RCPP
}

RcppExport SEXP Rfast_sum_upper_tri(SEXP xSEXP){
BEGIN_RCPP
    RObject __result;
    RNGScope __rngScope;
    traits::input_parameter< NumericMatrix >::type x(xSEXP);
    __result = wrap(sum_upper_tri(x));
    return __result;
END_RCPP
}
