% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_grassmann_runif.R
\name{grassmann.runif}
\alias{grassmann.runif}
\title{Generate Uniform Samples on Grassmann Manifold}
\usage{
grassmann.runif(n, k, p, type = c("list", "array", "riemdata"))
}
\arguments{
\item{n}{number of samples to be generated.}

\item{k}{dimension of the subspace.}

\item{p}{original dimension (of the ambient space).}

\item{type}{return type; \describe{
\item{\code{"list"}}{a length-\eqn{n} list of \eqn{(p\times k)} basis of \eqn{k}-subspaces.}
\item{\code{"array"}}{a \eqn{(p\times k\times n)} 3D array whose slices are \eqn{k}-subspace basis.}
\item{\code{"riemdata"}}{a S3 object. See \code{\link{wrap.grassmann}} for more details.}
}}
}
\value{
an object from one of the above by \code{type} option.
}
\description{
It generates \eqn{n} random samples from Grassmann manifold \eqn{Gr(k,p)}.
}
\examples{
#-------------------------------------------------------------------
#                 Draw Samples on Grassmann Manifold 
#-------------------------------------------------------------------
#  Multiple Return Types with 3 Observations of 5-dim subspaces in R^10
dat.list = grassmann.runif(n=3, k=5, p=10, type="list")
dat.arr3 = grassmann.runif(n=3, k=5, p=10, type="array")
dat.riem = grassmann.runif(n=3, k=5, p=10, type="riemdata")

}
\references{
\insertRef{chikuse_statistics_2003}{Riemann}
}
\seealso{
\code{\link{stiefel.runif}}, \code{\link{wrap.grassmann}}
}
\concept{grassmann}
