/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Iterator;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.broker.region.cursors.OrderedPendingList;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PrioritizedPendingList;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStoreCursor
extends AbstractPendingMessageCursor
implements MessageRecoveryListener {
    private static final Log LOG = LogFactory.getLog(AbstractStoreCursor.class);
    protected final Destination regionDestination;
    private final PendingList batchList;
    private Iterator<MessageReference> iterator = null;
    protected boolean batchResetNeeded = true;
    private boolean storeHasMessages = false;
    protected int size;
    private MessageId lastCachedId;
    private boolean hadSpace = false;

    protected AbstractStoreCursor(Destination destination) {
        super(destination != null ? destination.isPrioritizedMessages() : false);
        this.regionDestination = destination;
        this.batchList = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
    }

    public final synchronized void start() throws Exception {
        if (!this.isStarted()) {
            this.clear();
            super.start();
            this.resetBatch();
            this.size = this.getStoreSize();
            this.storeHasMessages = this.size > 0;
            this.setCacheEnabled(!this.storeHasMessages && this.useCache);
        }
    }

    public final synchronized void stop() throws Exception {
        this.resetBatch();
        super.stop();
        this.gc();
    }

    public final boolean recoverMessage(Message message) throws Exception {
        return this.recoverMessage(message, false);
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        boolean recovered = false;
        if (this.recordUniqueId(message.getMessageId())) {
            if (!cached) {
                message.setRegionDestination(this.regionDestination);
                if (message.getMemoryUsage() == null) {
                    message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                }
            }
            message.incrementReferenceCount();
            this.batchList.addMessageLast(message);
            this.clearIterator(true);
            recovered = true;
            this.storeHasMessages = true;
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(this + " - cursor got duplicate: " + message.getMessageId() + ", " + message.getPriority());
        }
        return recovered;
    }

    public final void reset() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error(this + " - Failed to fill batch", e);
                throw new RuntimeException(e);
            }
        }
        this.clearIterator(true);
        this.size();
    }

    public synchronized void release() {
        this.clearIterator(false);
    }

    private synchronized void clearIterator(boolean ensureIterator) {
        boolean haveIterator = this.iterator != null;
        this.iterator = null;
        if (haveIterator && ensureIterator) {
            this.ensureIterator();
        }
    }

    private synchronized void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.batchList.iterator();
        }
    }

    public final void finished() {
    }

    public final synchronized boolean hasNext() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error(this + " - Failed to fill batch", e);
                throw new RuntimeException(e);
            }
        }
        this.ensureIterator();
        return this.iterator.hasNext();
    }

    public final synchronized MessageReference next() {
        MessageReference result = null;
        if (!this.batchList.isEmpty() && this.iterator.hasNext()) {
            result = this.iterator.next();
        }
        this.last = result;
        if (result != null) {
            result.incrementReferenceCount();
        }
        return result;
    }

    public final synchronized void addMessageLast(MessageReference node) throws Exception {
        if (this.hasSpace()) {
            if (!this.isCacheEnabled() && this.size == 0 && this.isStarted() && this.useCache) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + " - enabling cache for empty store " + node.getMessageId());
                }
                this.setCacheEnabled(true);
            }
            if (this.isCacheEnabled()) {
                this.recoverMessage(node.getMessage(), true);
                this.lastCachedId = node.getMessageId();
            }
        } else if (this.isCacheEnabled()) {
            this.setCacheEnabled(false);
            if (this.lastCachedId != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + " - disabling cache" + ", lastCachedId: " + this.lastCachedId + " current node Id: " + node.getMessageId());
                }
                this.setBatch(this.lastCachedId);
                this.lastCachedId = null;
            }
        }
        this.storeHasMessages = true;
        ++this.size;
    }

    protected void setBatch(MessageId messageId) throws Exception {
    }

    public final synchronized void addMessageFirst(MessageReference node) throws Exception {
        this.setCacheEnabled(false);
        ++this.size;
    }

    public final synchronized void remove() {
        --this.size;
        if (this.iterator != null) {
            this.iterator.remove();
        }
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
    }

    public final synchronized void remove(MessageReference node) {
        --this.size;
        this.setCacheEnabled(false);
        this.batchList.remove(node);
    }

    public final synchronized void clear() {
        this.gc();
    }

    public synchronized void gc() {
        Iterator<MessageReference> i = this.batchList.iterator();
        while (i.hasNext()) {
            MessageReference msg = i.next();
            this.rollback(msg.getMessageId());
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
        this.clearIterator(false);
        this.batchResetNeeded = true;
        this.setCacheEnabled(false);
    }

    public boolean hasSpace() {
        this.hadSpace = super.hasSpace();
        return this.hadSpace;
    }

    protected final synchronized void fillBatch() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " - fillBatch");
        }
        if (this.batchResetNeeded) {
            this.resetBatch();
            this.batchResetNeeded = false;
        }
        if (this.batchList.isEmpty() && this.storeHasMessages && this.size > 0) {
            this.storeHasMessages = false;
            try {
                this.doFillBatch();
            }
            catch (Exception e) {
                LOG.error(this + " - Failed to fill batch", e);
                throw new RuntimeException(e);
            }
            if (!this.batchList.isEmpty() || !this.hadSpace) {
                this.storeHasMessages = true;
            }
        }
    }

    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized boolean hasMessagesBufferedToDeliver() {
        return !this.batchList.isEmpty();
    }

    public final synchronized int size() {
        if (this.size < 0) {
            this.size = this.getStoreSize();
        }
        return this.size;
    }

    public String toString() {
        return this.regionDestination.getActiveMQDestination().getPhysicalName() + ",batchResetNeeded=" + this.batchResetNeeded + ",storeHasMessages=" + this.storeHasMessages + ",size=" + this.size + ",cacheEnabled=" + this.isCacheEnabled();
    }

    protected abstract void doFillBatch() throws Exception;

    protected abstract void resetBatch();

    protected abstract int getStoreSize();

    protected abstract boolean isStoreEmpty();
}

