% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{as_harmonized_dossier}
\alias{as_harmonized_dossier}
\title{Validate and coerce as a harmonized dossier object}
\usage{
as_harmonized_dossier(
  object,
  dataschema = attributes(object)$`Rmonize::DataSchema`,
  data_proc_elem = attributes(object)$`Rmonize::Data Processing Elements`,
  harmonized_col_id = attributes(object)$`Rmonize::harmonized_col_id`,
  harmonized_col_dataset = attributes(object)$`Rmonize::harmonized_col_dataset`,
  harmonized_data_dict_apply = FALSE
)
}
\arguments{
\item{object}{A A potential harmonized dossier object to be coerced.}

\item{dataschema}{A DataSchema object.}

\item{data_proc_elem}{A Data Processing Elements object.}

\item{harmonized_col_id}{A character string identifying the name of the
column present in every dataset to use as a dataset identifier.}

\item{harmonized_col_dataset}{A character string identifying the column
to use for dataset names.}

\item{harmonized_data_dict_apply}{Whether to apply the dataschema to each
harmonized dataset. FALSE by default.}
}
\value{
A list of data frame(s), containing harmonized dataset(s).
The DataSchema and Data Processing Elements are preserved as attributes of
the output harmonized dossier.
}
\description{
Checks if an object is a valid harmonized dossier and returns it with the
appropriate \code{Rmonize::class} attribute. This function mainly helps validate
inputs within other functions of the package but could be used separately to
ensure that an object has an appropriate structure. The function
has two arguments that can optionally be declared by the user
(\code{unique_col_dataset} and \code{unique_col_id}). \code{unique_col_dataset} refers to
the columns which contains name of each harmonized dataset. \code{unique_col_id}
refers to the column in harmonized datasets which identifies unique
combinations of observation/dataset. These two columns are added to ensure
that there is always a unique entity identifier when datasets are pooled.
}
\details{
A harmonized dossier is a named list containing one or more data frames,
which are harmonized datasets. A harmonized dossier is generally the
product of applying processing to a dossier object The name of each
harmonized dataset (data frame) is taken from the reference input dataset.
A harmonized dossier also contains the DataSchema and
Data Processing Elements used in processing as attributes.

A DataSchema is the list of core variables to generate across datasets and
related metadata. A DataSchema object is a list of data frames with elements
named 'Variables' (required) and 'Categories' (if any). The 'Variables'
element must contain at least the \code{name} column, and the 'Categories'
element must contain at least the \code{variable} and \code{name} columns to be usable
in any function. In 'Variables' the \code{name} column must also have unique
entries, and in 'Categories' the combination of \code{variable} and \code{name} columns
must also be unique.

The Data Processing Elements specifies the algorithms used to process input
variables into harmonized variables in the DataSchema format. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).
}
\examples{
{

# Use Rmonize_DEMO to run examples.
library(dplyr)

glimpse(as_harmonized_dossier(Rmonize_DEMO$harmonized_dossier))
  
}

}
