% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{fnAggRadRast}
\alias{fnAggRadRast}
\title{Calculate statistics on a nightlight raster that fall within a polygon}
\usage{
fnAggRadRast(ctryPoly, ctryRastCropped, stats, nlType)
}
\arguments{
\item{ctryPoly}{The polygon of the admin level/region of interest. In general is a country polygon
with sub-regions usually the lowest known admin level as given by the GADM polygons.}

\item{ctryRastCropped}{The raster containing nightlight radiances to sum. Usually will have already be
cropped to the country outline}

\item{stats}{The statistics to calculate}

\item{nlType}{Character vector The nlType to process}
}
\value{
Integer Sum of radiances of all pixels in a raster that fall within a polygon region
}
\description{
Calculate stats on the radiance of the pixels in a nightlight raster
    that fall within a polygon and its subpolygons using the \code{raster} 
    package. Given a country polygon with subpolygons representing lower 
    admin levels, it will crop and mask the raster to each subpolygon and 
    calculate the total radiance for the polygon and return a vector of total
    radiances that matches the subpolygons
}
\examples{
#read the Kenya polygon downloaded from GADM and load the lowest admin level (ward)
\dontrun{
ctryPoly <- readOGR(getPolyFnamePath("KEN"), getCtryShpLowestLyrName("KEN"))
    
# the VIIRS nightlight raster cropped earlier to the country outline
ctryRastCropped <- getCtryRasterOutputFname("KEN","VIIRS","201401")

#calculate the sum of radiances for the wards in Kenya
sumAvgRadRast <- fnAggRadRast(ctryPoly, ctryRastCropped)
}
}
