% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{getPolyFnamePath}
\alias{getPolyFnamePath}
\title{Get the path of the unzipped polygon directory downloaded from GADM.ORG}
\usage{
getPolyFnamePath(ctryCode = NULL,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{character the ISO3 code of the country}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
character path to polygon shapefile directory
}
\description{
Get the path of the unzipped polygon directory downloaded from GADM.ORG. Note the polygons are in ESRI
    Shapefile format thus when unzipped create a directory with the name <ctrycode>_adm_shp e.g.
    KEN_adm_shp. The directory will contain a number of files including the .shp file. 
    \code{rgdal::readOGR} can read a shapefile polygon when given the directory path. It will
    determine which files to read.
}
\examples{
Rnightlights:::getPolyFnamePath("KEN")
 #returns "dataPath/polygons/KEN_adm_shp"
 
#@export only due to exploreData() shiny app
}
