% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-input-and-settings.R
\name{check_setup.BiBMA}
\alias{check_setup.BiBMA}
\title{Prints summary of \code{"BiBMA.reg"} ensemble implied by the specified priors
and formula}
\usage{
check_setup.BiBMA(
  priors_effect = prior(distribution = "student", parameters = list(location = 0, scale =
    0.58, df = 4)),
  priors_heterogeneity = prior(distribution = "invgamma", parameters = list(shape = 1.77,
    scale = 0.55)),
  priors_effect_null = prior(distribution = "point", parameters = list(location = 0)),
  priors_heterogeneity_null = prior(distribution = "point", parameters = list(location =
    0)),
  priors_baseline = NULL,
  priors_baseline_null = prior_factor("beta", parameters = list(alpha = 1, beta = 1),
    contrast = "independent"),
  models = FALSE,
  silent = FALSE,
  ...
)
}
\arguments{
\item{priors_effect}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "student",   parameters = list(location = 0, scale = 0.58, df = 4))},
based on logOR meta-analytic estimates from the Cochrane Database of Systematic Reviews
\insertCite{bartos2023empirical}{RoBMA}.}

\item{priors_heterogeneity}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "invgamma",  parameters = list(shape = 1.77, scale = 0.55))} that
is based on heterogeneities of logOR estimates from the Cochrane Database of Systematic Reviews
\insertCite{bartos2023empirical}{RoBMA}.}

\item{priors_effect_null}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero,
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_heterogeneity_null}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero (a fixed effect meta-analytic models),
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_baseline}{prior distributions for the alternative hypothesis about
intercepts (\code{pi}) of each study. Defaults to \code{NULL}.}

\item{priors_baseline_null}{prior distributions for the null hypothesis about
intercepts (\code{pi}) for each study. Defaults to an independent uniform prior distribution
for each intercept \code{prior("beta", parameters = list(alpha = 1, beta = 1), contrast = "independent")}.}

\item{models}{should the models' details be printed.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{check_setup.reg} invisibly returns list of summary tables.
}
\description{
\code{check_setup} prints summary of \code{"RoBMA.reg"} ensemble
implied by the specified prior distributions. It is useful for checking
the ensemble configuration prior to fitting all of the models.
}
\seealso{
\code{\link[=check_setup]{check_setup()}} \code{\link[=BiBMA]{BiBMA()}}
}
