\name{D.discretization.RST}
\alias{D.discretization.RST}
\title{The wrapper function of discretization methods}
\usage{
  D.discretization.RST(decision.table,
    type.method = "unsupervised.quantiles", ...)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing a decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{type.method}{one of the following methods:
  \itemize{ \item \code{"global.discernibility"}: See
  \code{\link{D.global.discernibility.heuristic.RST}}.
  \item \code{"local.disc.matrix"}: See
  \code{\link{D.local.discernibility.matrix.RST}}.  \item
  \code{"max.disc.matrix"}: See
  \code{\link{D.max.discernibility.matrix.RST}}.  \item
  \code{"unsupervised.intervals"}: See
  \code{\link{D.discretize.equal.intervals.RST}}.  \item
  \code{"unsupervised.quantiles"}: See
  \code{\link{D.discretize.quantiles.RST}}.  }}

  \item{...}{other parameters related to the corresponding
  methods.}
}
\value{
  A class \code{"Discretization"}. See
  \code{\link{D.local.discernibility.matrix.RST}}.
}
\description{
  It is a wrapper function collecting all discretization
  methods based on RST. It provides an additional interface
  that allows users to use the methods of the
  discretization easily.
}
\details{
  Discretization is used to convert continuous attributes
  into nominal ones in an information system. It is very
  important to perform this process since any methods based
  on rough set theory need nominal attributes to compute
  the indiscernibility relation or perform other functions.
  Furthermore, in order to avoid loss of information, in
  rough set theory point of view, the discernibility
  relation among objects is maintained.

  It should be noted that the output of this function is a
  class containing cut values. In order to generate a new
  decision table, the function
  \code{\link{SF.applyDecTable}} is executed.
}
\examples{
#################################################################
## Example: Determine cut values and generate new decision table
#################################################################
dt.ex1 <- data.frame(c(1, 2, 3, 3, 4, 5, 6, 7, 7, 8), c(2,5, 7, 6, 6, 6, 1, 8, 1, 1),
                             c(3, 5, 1, 1, 3, 6, 8, 8, 1, 1), c(0, 1, 2, 1, 0, 1, 2, 2, 0, 0))
colnames(dt.ex1) <- c("a1", "a2", "a3", "d")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4, indx.nominal = c(4))

cut.values <- D.discretization.RST(decision.table, type.method = "global.discernibility")

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, cut.values)
}
\seealso{
  \code{\link{BC.LU.approximation.RST}},
  \code{\link{BC.LU.approximation.FRST}}
}

