% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/IOFunctions.R
\name{print.RuleSetRST}
\alias{print.RuleSetRST}
\title{The print function for RST rule sets}
\usage{
\method{print}{RuleSetRST}(x, howMany = min(10, length(x)), ...)
}
\arguments{
\item{x}{a \code{"RuleSetRST"} object. See \code{\link{RI.LEM2Rules.RST}}.}

\item{howMany}{an integer giving the number of rules to be printed.
The default is minimum from 10 and the total number of rules in the set.}

\item{...}{the other parameters.}
}
\value{
prints its argument and returns it invisibly
}
\description{
A print method for RuleSetRST objects.
}
\examples{
###########################################################
## Example : Printing of a decision rule set problem
###########################################################
data(RoughSetData)
hiring.data <- RoughSetData$hiring.dt

rules <- RI.LEM2Rules.RST(hiring.data)

rules             # all rules are printed
print(rules, 2)   # only the first two rules are printed

# printing a subset of rules
rules[2:3]
}
\author{
Andrzej Janusz
}

