% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_mcd.R
\name{outliers_mcd}
\alias{outliers_mcd}
\title{MCD function to detect outliers}
\usage{
outliers_mcd(x, h, alpha, na.rm)
}
\arguments{
\item{x}{matrix of bivariate values from which we want to compute outliers}

\item{h}{proportion of dataset to use in order to compute sample means and covariances}

\item{alpha}{nominal type I error probability (by default .01)}

\item{na.rm}{set whether Missing Values should be excluded (na.rm = TRUE) or not (na.rm = FALSE) - defaults to TRUE}
}
\value{
Returns Call, Max distance, number of outliers
}
\description{
Detecting multivariate outliers using the Minimum Covariance Determinant approach
}
\examples{
#### Run outliers_mcd
# The default is to use 75\% of the datasets in order to compute sample means and covariances
# This proportion equals 1-breakdown points (i.e. h = .75 <--> breakdown points = .25)
# This breakdown points is encouraged by Leys et al. (2018)
data(Attacks)
SOC <- rowMeans(Attacks[,c("soc1r","soc2r","soc3r","soc4","soc5","soc6","soc7r",
"soc8","soc9","soc10r","soc11","soc12","soc13")])
HSC <- rowMeans(Attacks[,22:46])
res <- outliers_mcd(x = cbind(SOC,HSC), h = .5,na.rm = TRUE)
res

# Moreover, a list of elements can be extracted from the function,
# such as the position of outliers in the dataset
# and the coordinates of outliers
res$outliers_pos
res$outliers_val
}
\keyword{MMCD}
\keyword{outliers}
