% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_mad.R
\name{outliers_mad}
\alias{outliers_mad}
\title{MAD function to detect outliers}
\usage{
outliers_mad(x, b, threshold, na.rm)
}
\arguments{
\item{x}{vector of values from which we want to compute outliers}

\item{b}{constant depending on the assumed distribution underlying the data, that equals 1/Q(0.75).
When the normal distribution is assumed, the constant 1.4826 is used
(and it makes the MAD and SD of normal distributions comparable).}

\item{threshold}{the number of MAD considered as a threshold to consider a value an outlier}

\item{na.rm}{set whether Missing Values should be excluded (na.rm = TRUE) or not (na.rm = FALSE)
- defaults to TRUE}
}
\value{
Returns Call, median, MAD, limits of acceptable range of values, number of outliers
}
\description{
Detecting univariate outliers using the robust median absolute deviation
}
\examples{

#### Run outliers_mad
x <- runif(150,-100,100)
outliers_mad(x, b = 1.4826,threshold = 3,na.rm = TRUE)

#### Results can be stored in an object.
data(Intention)
res1=outliers_mad(Intention$age)
# Moreover, a list of elements can be extracted from the function,
# such as all the extremely high values,
# That will be sorted in ascending order
#### The function should be performed on dimension rather than on isolated items
data(Attacks)
SOC <- rowMeans(Attacks[,c("soc1r","soc2r","soc3r","soc4","soc5","soc6",
"soc7r","soc8","soc9","soc10r","soc11","soc12","soc13")])
res=outliers_mad(x = SOC)


}
\keyword{MAD}
\keyword{outliers}
