% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toSymbols.R
\name{toSymbols}
\alias{toSymbols}
\alias{toSymbols.integer}
\alias{toSymbols.numeric}
\alias{toSymbols.character}
\title{Atomic Symbols Converter}
\usage{
toSymbols(x, ...)

\method{toSymbols}{integer}(x, ...)

\method{toSymbols}{numeric}(x, ...)

\method{toSymbols}{character}(x, nletters = 3, ...)
}
\arguments{
\item{x}{a vector to be converted into atomic symbols.}

\item{\dots}{further arguments passed to or from other methods.}

\item{nletters}{an integer used to truncate the character strings before convertion.}
}
\value{
a character vector containing atomic symbols
}
\description{
Converts character strings or atomic numbers into atomic symbols.
}
\details{
Each elements of \code{x} are converted into atomic symbols.\cr
When \code{x} is an integer (or numeric) vector, atomic number are search into the \code{elements} data set to find associated atomic symbols.\cr
When \code{x} is a character vector, \code{toSymbols} first removes all leading and trailing white spaces and numbers.
Then translates the first character of the character strings to uppercase and all the others to lowercase.
Finally, the character strings are tested for matching with element symbols provided by the \code{elements} data set.
NA are produced for no matching.
}
\examples{
x <- c(1:10)
toSymbols(x)

x <- c("C  "," o","h1","1h","UU","SI0","cR")
toSymbols(x)

# 'nletters' can be used to truncate the character strings before
# conversion, if needed:
toSymbols("SIL", nletters=3) # return NA
toSymbols("SIL", nletters=2) # return "Si"
toSymbols("SIL", nletters=1) # return "S"

}
\seealso{
\code{\link{elements}}
}
\keyword{manip}
