% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_histogram_plot.R
\name{create_histogram_plot}
\alias{create_histogram_plot}
\title{create_histogram_plot}
\usage{
create_histogram_plot(
  df,
  aes_x = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  position = "stack",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  bins = 20,
  binwidth = NULL,
  bin_breaks = NULL,
  bin_class = NULL,
  bar_fill = NA,
  bar_color = "black",
  bar_alpha = 1,
  bar_lwd = 1,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  x_decimals = NULL,
  x_scientific = NULL,
  x_log10 = FALSE,
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  axis_text_size = 11,
  do_coord_flip = FALSE,
  bar_labels = FALSE,
  bar_label_size = 6,
  bar_label_color = "black",
  plot_obs = FALSE,
  plot_obs_len = 0.02,
  plot_obs_color = "black",
  bold_x = NULL,
  bold_x_color = "black",
  bold_x_linetype = "dashed",
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  show_legend = TRUE,
  panel_color = "white",
  panel_border_color = "black",
  legend_pos = "top",
  legend_key_width = 0.7,
  legend_key_height = 0.7,
  legend_key_backgrd = "white",
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The target data frame for the bar chart.}

\item{aes_x}{A required string that sets the x axis continuous variable name from 'df'.}

\item{aes_color}{Sets the variable name from 'df' for the aesthetic mapping for color.}

\item{aes_fill}{Sets the variable name from 'df' for the aesthetic mapping for fill.}

\item{position}{A string that sets the bar positions.  Acceptable values are "dodge", "dodge2"(side by side),
"identity"(overlap) or "stack".}

\item{title}{A string that sets the overall title.}

\item{subtitle}{A string that sets the overall subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default) then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{bins}{An integer that sets the number of bins of the histogram. Is overridden by a non-null value for either 'binwidth',
'bin_breaks' or 'bins_class'. Default is 20.}

\item{binwidth}{A numeric that sets the number of bins based on this value.  If 'aes_x' is a
date variable then 'binwidth' is the number of days and if a time variable then 'binwidth' is
the number of seconds.}

\item{bin_breaks}{A numeric vector that sets the number of bins by giving the bin boundaries explicitly.}

\item{bin_class}{A character string that sets the number of bins by selecting one of three types of formulas. Acceptable values are
"Sturges", "Scott", or "FD".}

\item{bar_fill}{A string that sets the fill color attribute for the bars.}

\item{bar_color}{A string that sets the outline color attribute for the bars.}

\item{bar_alpha}{A numeric that set the alpha component attribute to 'bar_color'.}

\item{bar_lwd}{A numeric that sets the bar's outline line width attribute.}

\item{x_limits}{A numeric 2 element vector or function that sets the minimum and maximum for the x axis.  Use NA to
refer to the existing minimum and maximum.}

\item{x_major_breaks}{A numeric vector or function that sets the major tic locations along the x axis.}

\item{x_minor_breaks}{A numeric vector or function that sets the minor tic locations along the x axis.}

\item{x_labels}{A character vector or function giving x axis tic labels.  Must be the same length as 'x_major_breaks'.}

\item{x_decimals}{A numeric that sets the number of decimal places for x-tic labels.}

\item{x_scientific}{A logical which if \code{TRUE} will put the x-tic labels in scientific notation.}

\item{x_log10}{A logical which if \code{TRUE} will use a log10 scale for the x axis.}

\item{y_limits}{A numeric 2 element vector or function that sets the minimum and maximum for the y axis.  Use NA to
refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that sets the major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that sets the minor tic locations along the y axis.}

\item{y_labels}{A character vector or function giving y axis tic labels.  Must be the same length as 'y_major_breaks'.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{do_coord_flip}{A logical which if TRUE will flip the x and y axis'.}

\item{bar_labels}{A logical which if \code{TRUE} will label each bar with its value.}

\item{bar_label_size}{A numeric that sets the size of the bar labels}

\item{bar_label_color}{A string that sets the color of the bar labels}

\item{plot_obs}{A logical which if \code{TRUE} plots a line for each observation along the axis margin.}

\item{plot_obs_len}{A numeric that sets the length of the 'plot_obs' lines.}

\item{plot_obs_color}{A string that sets the color of the 'plot_obs' lines.}

\item{bold_x}{A numeric that sets the x-intercept for plotting a bold vertical line.}

\item{bold_x_color}{A string that sets the color of 'bold_x'.}

\item{bold_x_linetype}{A string that set the linetype of 'bold_x'.}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function plots a ggplot2 based histogram with options for scaling and viewing observation locations. The function
  offers one of four ways of setting the number of bins.
}
\examples{
library(ggplot2)
library(data.table)
library(rlang)
library(RplotterPkg)

RplotterPkg::create_histogram_plot(
  df = RplotterPkg::midwest,
  aes_x = "Area",
  binwidth = 0.01,
  x_limits = c(0.0, 0.11),
  x_major_breaks = seq(0.0, 0.11, 0.01),
  title = "Distribution of area",
  subtitle = "437 counties from midwest dataset",
  x_title = "Area",
  y_title = "Count",
  bar_color = "white",
  bar_lwd = 2.0,
  bar_fill = "brown",
  do_coord_flip = TRUE,
  bar_labels = TRUE,
  bar_label_size = 4,
  bar_label_color = "blue",
  rot_y_tic_label = TRUE,
  silent_NA_warning = TRUE,
  plot_obs = TRUE,
  plot_obs_color = "darkorange"
)

}
