% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_sound_selection.R
\name{to_sound_selection}
\alias{to_sound_selection}
\title{Convert Raven's selection files into sound selection files}
\usage{
to_sound_selection(path = NULL, dest.path = NULL, recursive = FALSE,
 parallel = 1, pb = TRUE, sound.file.path, sound.file.col)
}
\arguments{
\item{path}{A character string indicating the path of the directory in which to look for the 'Raven' selection (text) files. 
If not provided (default) the function searches into the current working directory.}

\item{dest.path}{A character string indicating the path of the directory in which
sound selection tables will be saved. 
If not provided (default) files will be saved in directory where the original raven selections were found.}

\item{recursive}{Logical. If \code{TRUE} the listing recurses into sub-directories.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{sound.file.path}{A character string indicating the path of the 
directory containing the sound file(s). This argument is required.}

\item{sound.file.col}{A character string with the name of the column containing the sound file names in 
the selection text files. Required.}
}
\value{
Sound selection table file(s) saved in 'dest.path' or in the working 
directory.
}
\description{
\code{to_sound_selection} converts Raven's selection files into sound selection files
}
\details{
The function converts Raven's selection tables to sound selection tables.
 Sound selection table is a more convenient format as it can be open directly in Raven (or drag-and-drop) and 
 will automatically open the associated sound file. Multiple files can be 
 simultaneously converted. Files must be in '.txt' format. Selection 
files including data from multiple recordings can be converted only if all the 
correspondent sound files are found in the same directory. Note that no data is 
imported into the R environment.
}
\examples{
{

#load data 
data(selection_files)

# save 'Raven' selection tables in the temporary directory
out <- lapply(1:2, function(x)
writeLines(selection_files[[x]], con = file.path(tempdir(), names(selection_files)[x])))

# try drag and drop selection files into Raven (shouldn't work)

# now convert files
to_sound_selection(sound.file.path = tempdir(), 
sound.file.col = "Begin Path", path = tempdir())

# try drag and drop into Raven again (should work now)
}

}
\seealso{
\code{\link{imp_syrinx}}; \code{\link{imp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
